/*-----------------------------------------------------------------------------

 1999, Steinberg Soft und Hardware GmbH, All Rights Reserved

-----------------------------------------------------------------------------*/

#include <stdio.h>

#ifndef __VstXSynth__
#include "vstxsynth.h"
#endif

extern bool oome;

//-----------------------------------------------------------------------------------------
// VstXSynthProgram
//-----------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------
VstXSynthProgram::VstXSynthProgram ()
{
	fWaveform1 = 0.f;	// saw
	fFreq1 =.0f;
	fVolume1 = .33f;
	fWaveform2 = 1.f;	// pulse
	fFreq2 = .005f;		// slightly higher
	fVolume2 = .33f;
	fWaveform3 = 0.f;	// saw
	fFreq3 = .01f;		// slightly higher
	fVolume3 = .33f;
	fVolume = .9f;
	strcpy (name, "Basic");
}

//-----------------------------------------------------------------------------------------
// VstXSynth
//-----------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------
VstXSynth::VstXSynth (audioMasterCallback audioMaster) : AudioEffectX (audioMaster, kNumPrograms, kNumParams)
{
	programs = new VstXSynthProgram[kNumPrograms];
	if (programs)
		setProgram (0);
	else
		oome = true;
	if (audioMaster)
	{
		setNumInputs (0);				// no inputs
		setNumOutputs (kNumOutputs);	// 3 outputs, 1 for each osciallator
		canProcessReplacing ();
		hasVu (false);
		hasClip (false);
		isSynth ();
		setUniqueID ('VxSy');			// <<<! *must* change this!!!!
	}
	initProcess ();
	suspend ();
}

//-----------------------------------------------------------------------------------------
VstXSynth::~VstXSynth ()
{
	if (programs)
		delete[] programs;
}

//-----------------------------------------------------------------------------------------
void VstXSynth::setProgram (long program)
{
	VstXSynthProgram *ap = &programs[program];
	curProgram = program;
	fWaveform1 = ap->fWaveform1;
	fFreq1 = ap->fFreq1;
	fVolume1 = ap->fVolume1;
	fWaveform2 = ap->fWaveform2;
	fFreq2 = ap->fFreq2;
	fVolume2 = ap->fVolume2;
	fWaveform3 = ap->fWaveform2;
	fFreq3 = ap->fFreq2;
	fVolume3 = ap->fVolume2;
	fVolume = ap->fVolume;
}

//-----------------------------------------------------------------------------------------
void VstXSynth::setProgramName (char *name)
{
	strcpy (programs[curProgram].name, name);
}

//-----------------------------------------------------------------------------------------
void VstXSynth::getProgramName (char *name)
{
	strcpy (name, programs[curProgram].name);
}

//-----------------------------------------------------------------------------------------
void VstXSynth::getParameterLabel (long index, char *label)
{
	switch (index)
	{
		case kWaveform1:
		case kWaveform2:
		case kWaveform3:	strcpy (label, " Shape  ");		break;
		case kFreq1:
		case kFreq2:
		case kFreq3:		strcpy (label, "   Hz   ");		break;
		case kVolume1:
		case kVolume2:
		case kVolume3:
		case kVolume:		strcpy (label, "   dB   ");		break;
	}
}

//-----------------------------------------------------------------------------------------
void VstXSynth::getParameterDisplay (long index, char *text)
{
	text[0] = 0;
	switch (index)
	{
		case kWaveform1:
			if (fWaveform1 < .5)
				strcpy (text, "Sawtooth");
			else
				strcpy (text, "Pulse   ");
			break;
		case kFreq1:		float2string (fFreq1, text);		break;
		case kVolume1:		dB2string (fVolume1, text);		break;
		case kWaveform2:
			if (fWaveform2 < .5)
				strcpy (text, "Sawtooth");
			else
				strcpy (text, "Pulse   ");
			break;
		case kFreq2:		float2string (fFreq2, text);		break;
		case kVolume2:		dB2string (fVolume2, text);		break;
		case kWaveform3:
			if (fWaveform3 < .5)
				strcpy (text, "Sawtooth");
			else
				strcpy (text, "Pulse   ");
			break;
		case kFreq3:		float2string (fFreq3, text);		break;
		case kVolume3:		dB2string (fVolume3, text);		break;
		case kVolume:		dB2string (fVolume, text);		break;
	}
}

//-----------------------------------------------------------------------------------------
void VstXSynth::getParameterName (long index, char *label)
{
	switch (index)
	{
		case kWaveform1:	strcpy (label, " Wave 1 ");		break;
		case kFreq1:		strcpy (label, " Freq 1 ");		break;
		case kVolume1:		strcpy (label, " Levl 1 ");		break;
		case kWaveform2:	strcpy (label, " Wave 2 ");		break;
		case kFreq2:		strcpy (label, " Freq 2 ");		break;
		case kVolume2:		strcpy (label, " Levl 2 ");		break;
		case kWaveform3:	strcpy (label, " Wave 3 ");		break;
		case kFreq3:		strcpy (label, " Freq 3 ");		break;
		case kVolume3:		strcpy (label, " Levl 3 ");		break;
		case kVolume:		strcpy (label, " Volume ");		break;
	}
}

//-----------------------------------------------------------------------------------------
void VstXSynth::setParameter (long index, float value)
{
	VstXSynthProgram *ap = &programs[curProgram];
	switch (index)
	{
		case kWaveform1:	fWaveform1	= ap->fWaveform1	= value;	break;
		case kFreq1:		fFreq1 		= ap->fFreq1		= value;	break;
		case kVolume1:		fVolume1	= ap->fFreq1		= value;	break;
		case kWaveform2:	fWaveform2	= ap->fWaveform2	= value;	break;
		case kFreq2:		fFreq2		= ap->fFreq2		= value;	break;
		case kVolume2:		fVolume2	= ap->fVolume2		= value;	break;
		case kWaveform3:	fWaveform3	= ap->fWaveform3	= value;	break;
		case kFreq3:		fFreq3		= ap->fFreq3		= value;	break;
		case kVolume3:		fVolume3	= ap->fVolume3		= value;	break;
		case kVolume:		fVolume		= ap->fVolume		= value;	break;
		case kTest:
			if (value < .5)
				noteOn (0x40, 0x64, 0);
			else
				noteIsOn = false;
			break;
	}
}

//-----------------------------------------------------------------------------------------
float VstXSynth::getParameter (long index)
{
	float value = 0;
	switch (index)
	{
		case kWaveform1:	value = fWaveform1;	break;
		case kFreq1:		value = fFreq1;		break;
		case kVolume1:		value = fVolume1;	break;
		case kWaveform2:	value = fWaveform2;	break;
		case kFreq2:		value = fFreq2;		break;
		case kVolume2:		value = fVolume2;	break;
		case kWaveform3:	value = fWaveform3;	break;
		case kFreq3:		value = fFreq3;		break;
		case kVolume3:		value = fVolume3;	break;
		case kVolume:		value = fVolume;	break;
	}
	return value;
}

//-----------------------------------------------------------------------------------------
bool VstXSynth::getOutputProperties (long index, VstPinProperties* properties)
{
	if (index < kNumOutputs)
	{
		sprintf (properties->label, "Vstx %1d", index + 1);
		properties->flags = kVstPinIsActive;
		if (index < 2)
			properties->flags |= kVstPinIsStereo;	// test, make channel 1+2 stereo
		return true;
	}
	return false;
}

//-----------------------------------------------------------------------------------------
bool VstXSynth::getProgramNameIndexed (long category, long index, char* text)
{
	if (index < kNumPrograms)
	{
		strcpy (text, programs[index].name);
		return true;
	}
	return false;
}

//-----------------------------------------------------------------------------------------
bool VstXSynth::copyProgram (long destination)
{
	if (destination < kNumPrograms)
	{
		programs[destination] = programs[curProgram];
		return true;
	}
	return false;
}

//-----------------------------------------------------------------------------------------
bool VstXSynth::getEffectName (char* name)
{
	strcpy (name, "VstXSynth");
	return true;
}

//-----------------------------------------------------------------------------------------
bool VstXSynth::getVendorString (char* text)
{
	strcpy (text, "Steinberg");
	return true;
}

//-----------------------------------------------------------------------------------------
bool VstXSynth::getProductString (char* text)
{
	strcpy (text, "Vst Test Synth");
	return true;
}

//-----------------------------------------------------------------------------------------
long VstXSynth::canDo (char* text)
{
	if (!strcmp (text, "receiveVstEvents"))
		return 1;
	if (!strcmp (text, "receiveVstMidiEvent"))
		return 1;
	return -1;
}

